<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CamionController extends Controller
{
    public function index()
    {
        $camiones = DB::table('camiones as c')
            ->leftJoin('conductores as d', 'd.id', '=', 'c.driver_id')
            ->select(
                'c.*',
                DB::raw("CONCAT(d.first_name, ' ', d.last_name) as conductor_name"),
                'd.license_number'
            )
            ->orderBy('c.id', 'desc')
            ->paginate(10);

        $total = DB::table('camiones')->count();

        $por_estado = DB::table('camiones')
            ->select('status', DB::raw('COUNT(*) as total'))
            ->groupBy('status')
            ->pluck('total', 'status');

        $all_statuses = ['Activo', 'Inactivo', 'En Taller', 'Sin Asignar'];
        foreach ($all_statuses as $estado) {
            if (!isset($por_estado[$estado])) $por_estado[$estado] = 0;
        }

        $conductores = DB::table('conductores')
            ->select('id', 'first_name', 'last_name', 'license_number', 'status')
            ->where('status', '!=', 'Inactivo')
            ->orderBy('first_name')
            ->get();

        return view('camiones.index', compact('camiones', 'total', 'por_estado', 'conductores'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'unidad' => 'required|string|max:100',
            'placa' => 'required|string|max:100',
            'marca' => 'required|string|max:100',
            'modelo' => 'required|string|max:100',
            'vin' => 'nullable|string|max:100',
            'poliza_numero' => 'nullable|string|max:100',
            'fecha_expiracion_seguro' => 'nullable|date',
            'capacidad_carga' => 'nullable|string|max:100',
            'status' => 'required|string|max:50',
            'driver_id' => 'nullable|integer|exists:conductores,id',
            'poliza_documento' => 'nullable|file|mimes:jpg,jpeg,png,pdf|max:5120',
            'tarjeta_circulacion' => 'nullable|file|mimes:jpg,jpeg,png,pdf|max:5120',
        ]);

        $validated['poliza_documento'] = $request->file('poliza_documento')?->store('camiones/polizas', 'public');
        $validated['tarjeta_circulacion'] = $request->file('tarjeta_circulacion')?->store('camiones/tarjetas', 'public');

        DB::table('camiones')->insert($validated);

        return response()->json(['success' => true]);
    }

    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'unidad' => 'required|string|max:100',
            'placa' => 'required|string|max:100',
            'marca' => 'required|string|max:100',
            'modelo' => 'required|string|max:100',
            'vin' => 'nullable|string|max:100',
            'poliza_numero' => 'nullable|string|max:100',
            'fecha_expiracion_seguro' => 'nullable|date',
            'capacidad_carga' => 'nullable|string|max:100',
            'status' => 'required|string|max:50',
            'driver_id' => 'nullable|integer|exists:conductores,id',
            'poliza_documento' => 'nullable|file|mimes:jpg,jpeg,png,pdf|max:5120',
            'tarjeta_circulacion' => 'nullable|file|mimes:jpg,jpeg,png,pdf|max:5120',
        ]);

        if ($request->hasFile('poliza_documento')) {
            $validated['poliza_documento'] = $request->file('poliza_documento')->store('camiones/polizas', 'public');
        }
        if ($request->hasFile('tarjeta_circulacion')) {
            $validated['tarjeta_circulacion'] = $request->file('tarjeta_circulacion')->store('camiones/tarjetas', 'public');
        }

        DB::table('camiones')->where('id', $id)->update($validated);

        return response()->json(['success' => true]);
    }
}
