<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Client;

class ClientController extends Controller
{
    public function index()
    {
        $clients = Client::orderBy('id', 'desc')->paginate(10);

        $total = Client::count();
        $activos = Client::where('status', 'Activo')->count();
        $inactivos = Client::where('status', 'Inactivo')->count();

        return view('clients.index', compact('clients', 'total', 'activos', 'inactivos'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'client' => 'required|string|max:255',
            'contact_name' => 'required|string|max:255',
            'contact_email' => 'nullable|email',
            'contact_phone' => 'nullable|string|max:50',
        ]);

        Client::create([
            'client' => $request->client,
            'contact_name' => $request->contact_name,
            'contact_email' => $request->contact_email,
            'contact_phone' => $request->contact_phone,
            'email' => $request->email,
            'phone' => $request->phone,
            'status' => $request->status ?? 'Activo',
        ]);

        return response()->json(['success' => true]);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'client' => 'required|string|max:255',
            'contact_name' => 'required|string|max:255',
            'contact_email' => 'nullable|email',
            'contact_phone' => 'nullable|string|max:50',
        ]);

        $client = Client::findOrFail($id);
        $client->update([
            'client' => $request->client,
            'contact_name' => $request->contact_name,
            'contact_email' => $request->contact_email,
            'contact_phone' => $request->contact_phone,
            'email' => $request->email,
            'phone' => $request->phone,
            'status' => $request->status,
        ]);

        return response()->json(['success' => true]);
    }
}
