<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class InventarioController extends Controller
{
public function index()
{
    $productos = DB::table('inventario as i')
        ->leftJoin('bodegas as b', 'b.id', '=', 'i.bodega_id')
        ->leftJoin('categorias as c', 'c.id', '=', 'i.categoria_id')
        ->leftJoin('unidades_medida as u', 'u.id', '=', 'i.unidad_medida_id')
        ->leftJoin('vendors as v', 'v.id', '=', 'i.vendor_id')
        ->select(
            'i.*',
            'b.nombre as bodega_nombre',
            'c.nombre as categoria_nombre',
            'u.nombre as unidad_nombre',
            'u.simbolo as unidad_simbolo',
            'v.nombre as vendor_nombre'
        )
        ->orderBy('i.id', 'desc')
        ->paginate(10);

    $total = DB::table('inventario')->count();
    $por_estado = DB::table('inventario')
        ->select('status', DB::raw('COUNT(*) as total'))
        ->groupBy('status')
        ->pluck('total', 'status');

    $categorias = DB::table('categorias')->get();
    $unidades = DB::table('unidades_medida')->get();
    $bodegas = DB::table('bodegas')->get();
    $vendors = DB::table('vendors')->get();

    return view('inventario.index', compact('productos', 'total', 'por_estado', 'categorias', 'unidades', 'bodegas', 'vendors'));
}


public function store(Request $request)
{
    DB::table('inventario')->insert([
        'nombre' => $request->nombre,
        'codigo' => $request->codigo,
        'categoria_id' => $request->categoria_id,
        'unidad_medida_id' => $request->unidad_medida_id,
        'bodega_id' => $request->bodega_id,
        'vendor_id' => $request->vendor_id,
        'precio_compra' => $request->precio_compra,
        'precio_venta' => $request->precio_venta,
        'stock_actual' => $request->stock_actual,
        'stock_minimo' => $request->stock_minimo,
        'status' => $request->status,
        'created_at' => now(),
        'updated_at' => now()
    ]);

    return response()->json(['success' => true]);
}

public function update(Request $request, $id)
{
    DB::table('inventario')->where('id', $id)->update([
        'nombre' => $request->nombre,
        'codigo' => $request->codigo,
        'categoria_id' => $request->categoria_id,
        'unidad_medida_id' => $request->unidad_medida_id,
        'bodega_id' => $request->bodega_id,
        'vendor_id' => $request->vendor_id,
        'precio_compra' => $request->precio_compra,
        'precio_venta' => $request->precio_venta,
        'stock_actual' => $request->stock_actual,
        'stock_minimo' => $request->stock_minimo,
        'status' => $request->status,
        'updated_at' => now()
    ]);

    return response()->json(['success' => true]);
}


}
