<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProveedorController extends Controller
{
    public function index()
    {
        $proveedores = DB::table('vendors')
            ->orderBy('id', 'desc')
            ->paginate(10);

        $total = DB::table('vendors')->count();

        return view('proveedores.index', compact('proveedores', 'total'));
    }

    public function store(Request $request)
    {
        DB::table('vendors')->insert([
            'nombre' => $request->nombre,
            'descripcion' => $request->descripcion,
            'ubicacion' => $request->ubicacion,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return response()->json(['success' => true]);
    }

    public function update(Request $request, $id)
    {
        DB::table('vendors')->where('id', $id)->update([
            'nombre' => $request->nombre,
            'descripcion' => $request->descripcion,
            'ubicacion' => $request->ubicacion,
            'updated_at' => now(),
        ]);

        return response()->json(['success' => true]);
    }

    public function destroy($id)
    {
        DB::table('vendors')->where('id', $id)->delete();
        return response()->json(['success' => true]);
    }
}
