

<?php $__env->startSection('title', 'Inventario - J&D'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-container">
  <div class="page-header">
    <h1 class="page-title">Inventario</h1>
    <p class="page-subtitle">Gestión completa de productos y existencias del sistema Comercializadora J&D</p>
  </div>

  <!-- 📊 Stats -->
  <div class="row mb-4 justify-content-center">
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card total">
        <p class="stats-title">Total Productos</p>
        <h2 class="stats-value"><?php echo e($total); ?></h2>
      </div>
    </div>

    <?php
      $statuses = ['Disponible'=>'active','Agotado'=>'warning','Inactivo'=>'inactive'];
    ?>
    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado => $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="col-md-3 col-sm-6 mb-3">
        <div class="stats-card <?php echo e($class); ?>">
          <p class="stats-title"><?php echo e($estado); ?></p>
          <h2 class="stats-value"><?php echo e($por_estado[$estado] ?? 0); ?></h2>
        </div>
      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>

  <!-- 🧾 Table -->
  <div class="table-container">
    <div class="table-header">
      <h3 class="table-title">Lista de Productos</h3>
      <button class="btn btn-primary-custom ms-auto" data-bs-toggle="modal" data-bs-target="#newProductoModal">
        <i class="fas fa-plus me-2"></i>Nuevo Producto
      </button>
    </div>

    <!-- Filters -->
    <div class="p-3 bg-light border-bottom">
      <div class="row g-3">
        <div class="col-md-4">
          <input type="text" id="filterName" class="form-control" placeholder="Buscar por nombre...">
        </div>
        <div class="col-md-4">
          <input type="text" id="filterCategoria" class="form-control" placeholder="Buscar por categoría...">
        </div>
        <div class="col-md-4">
          <select id="filterStatus" class="form-select">
            <option value="">Todos los estados</option>
            <option>Disponible</option>
            <option>Agotado</option>
            <option>Inactivo</option>
          </select>
        </div>
      </div>
    </div>

    <div class="table-responsive">
      <table id="inventarioTable" class="table table-hover align-middle mb-0">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Foto</th>
            <th>Producto</th>
            <th>Categoría</th>
            <th>Unidad</th>
            <th>Stock</th>
            <th>Precio Venta</th>
            <th>Bodega</th>
            <th>Proveedor</th>
            <th>Estado</th>
            <th class="text-center">Acciones</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($p->id); ?></td>
            <td>
              <?php if($p->foto): ?>
                <img src="<?php echo e(asset('storage/'.$p->foto)); ?>" width="45" height="45" class="rounded object-fit-cover">
              <?php else: ?>
                <i class="fa-solid fa-box text-secondary fs-4"></i>
              <?php endif; ?>
            </td>
            <td><?php echo e($p->nombre); ?></td>
            <td><?php echo e($p->categoria_nombre ?? '—'); ?></td>
            <td><?php echo e($p->unidad_nombre ?? $p->unidad_simbolo ?? '—'); ?></td>
            <td><strong><?php echo e($p->stock_actual); ?></strong></td>
            <td>Q<?php echo e(number_format($p->precio_venta,2)); ?></td>
            <td><?php echo e($p->bodega_nombre ?? '—'); ?></td>
            <td><?php echo e($p->vendor_nombre ?? '—'); ?></td>
            <td>
              <span class="badge 
                <?php switch($p->status):
                  case ('Disponible'): ?> badge-active <?php break; ?>
                  <?php case ('Agotado'): ?> badge-warning <?php break; ?>
                  <?php default: ?> badge-inactive
                <?php endswitch; ?>">
                <?php echo e($p->status); ?>

              </span>
            </td>
            <td class="text-center">
              <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#viewModal<?php echo e($p->id); ?>"><i class="fas fa-eye"></i></button>
              <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#editModal<?php echo e($p->id); ?>"><i class="fas fa-edit"></i></button>
            </td>
          </tr>

          <!-- 👁️ View Modal -->
          <div class="modal fade" id="viewModal<?php echo e($p->id); ?>" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Detalles del Producto</h5>
                  <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <div class="row">
                    <div class="col-md-4 text-center">
                      <?php if($p->foto): ?>
                        <img src="<?php echo e(asset('storage/'.$p->foto)); ?>" width="150" class="rounded mb-3 shadow-sm">
                      <?php else: ?>
                        <i class="fa-solid fa-box fa-5x text-secondary mb-3"></i>
                      <?php endif; ?>
                    </div>
                    <div class="col-md-8">
                      <p><strong>Nombre:</strong> <?php echo e($p->nombre); ?></p>
                      <p><strong>Categoría:</strong> <?php echo e($p->categoria_nombre ?? '—'); ?></p>
                      <p><strong>Unidad:</strong> <?php echo e($p->unidad_nombre ?? $p->unidad_simbolo ?? '—'); ?></p>
                      <p><strong>Precio Compra:</strong> Q<?php echo e(number_format($p->precio_compra,2)); ?></p>
                      <p><strong>Precio Venta:</strong> Q<?php echo e(number_format($p->precio_venta,2)); ?></p>
                      <p><strong>Stock Actual:</strong> <?php echo e($p->stock_actual); ?></p>
                      <p><strong>Bodega:</strong> <?php echo e($p->bodega_nombre ?? '—'); ?></p>
                      <p><strong>Proveedor:</strong> <?php echo e($p->vendor_nombre ?? '—'); ?></p>
                      <p><strong>Estado:</strong> <?php echo e($p->status); ?></p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- ✏️ Edit Modal -->
          <div class="modal fade" id="editModal<?php echo e($p->id); ?>" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Editar Producto</h5>
                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <form class="editProductoForm" data-id="<?php echo e($p->id); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="row">
                      <div class="col-md-6 mb-2"><input type="text" name="nombre" class="form-control" value="<?php echo e($p->nombre); ?>" required></div>
                      <div class="col-md-6 mb-2"><input type="text" name="codigo" class="form-control" value="<?php echo e($p->codigo); ?>" placeholder="Código"></div>

                      <div class="col-md-6 mb-2">
                        <label class="form-label">Categoría</label>
                        <select name="categoria_id" class="form-select" required>
                          <option value="">Seleccionar categoría</option>
                          <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($cat->id); ?>" <?php echo e($p->categoria_id == $cat->id ? 'selected' : ''); ?>><?php echo e($cat->nombre); ?></option>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                      </div>

                      <div class="col-md-6 mb-2">
                        <label class="form-label">Unidad de Medida</label>
                        <select name="unidad_medida_id" class="form-select" required>
                          <option value="">Seleccionar unidad</option>
                          <?php $__currentLoopData = $unidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($u->id); ?>" <?php echo e($p->unidad_medida_id == $u->id ? 'selected' : ''); ?>><?php echo e($u->nombre); ?> (<?php echo e($u->simbolo); ?>)</option>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                      </div>

                      <div class="col-md-12 mb-2">
                        <label class="form-label">Bodega</label>
                        <select name="bodega_id" class="form-select">
                          <option value="">Seleccionar bodega</option>
                          <?php $__currentLoopData = $bodegas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($b->id); ?>" <?php echo e($p->bodega_id == $b->id ? 'selected' : ''); ?>><?php echo e($b->nombre); ?></option>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                      </div>

                      <div class="col-md-12 mb-2">
                        <label class="form-label">Proveedor</label>
                        <select name="vendor_id" class="form-select">
                          <option value="">Seleccionar proveedor</option>
                          <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($v->id); ?>" <?php echo e($p->vendor_id == $v->id ? 'selected' : ''); ?>><?php echo e($v->nombre); ?></option>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                      </div>

                      <div class="col-md-6 mb-2"><input type="number" name="precio_compra" step="0.01" class="form-control" value="<?php echo e($p->precio_compra); ?>" placeholder="Precio Compra"></div>
                      <div class="col-md-6 mb-2"><input type="number" name="precio_venta" step="0.01" class="form-control" value="<?php echo e($p->precio_venta); ?>" placeholder="Precio Venta"></div>
                      <div class="col-md-6 mb-2"><input type="number" name="stock_actual" step="0.01" class="form-control" value="<?php echo e($p->stock_actual); ?>" placeholder="Stock Actual"></div>
                      <div class="col-md-6 mb-2"><input type="number" name="stock_minimo" step="0.01" class="form-control" value="<?php echo e($p->stock_minimo); ?>" placeholder="Stock Mínimo"></div>

                      <div class="col-md-6 mb-2">
                        <label>Foto del Producto</label>
                        <input type="file" name="foto" class="form-control">
                        <?php if($p->foto): ?>
                          <a href="<?php echo e(asset('storage/'.$p->foto)); ?>" target="_blank" class="small d-block mt-1 text-primary">📸 Ver actual</a>
                        <?php endif; ?>
                      </div>

                      <div class="col-md-6 mb-2">
                        <select name="status" class="form-select">
                          <option <?php echo e($p->status=='Disponible'?'selected':''); ?>>Disponible</option>
                          <option <?php echo e($p->status=='Agotado'?'selected':''); ?>>Agotado</option>
                          <option <?php echo e($p->status=='Inactivo'?'selected':''); ?>>Inactivo</option>
                        </select>
                      </div>
                    </div>
                    <button type="submit" class="btn btn-primary-custom w-100 mt-3">Guardar Cambios</button>
                  </form>
                </div>
              </div>
            </div>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>

    <div class="pagination-container p-3">
      <?php echo e($productos->links('pagination::bootstrap-5')); ?>

    </div>
  </div>
</div>

<!-- ➕ Nuevo Producto -->
<div class="modal fade" id="newProductoModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">Nuevo Producto</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="newProductoForm" enctype="multipart/form-data"><?php echo csrf_field(); ?>
          <div class="row">
            <div class="col-md-6 mb-2"><input type="text" name="nombre" class="form-control" placeholder="Nombre del producto" required></div>
            <div class="col-md-6 mb-2"><input type="text" name="codigo" class="form-control" placeholder="Código interno"></div>

            <div class="col-md-6 mb-2">
              <label class="form-label">Categoría</label>
              <select name="categoria_id" class="form-select" required>
                <option value="">Seleccionar categoría</option>
                <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->nombre); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>

            <div class="col-md-6 mb-2">
              <label class="form-label">Unidad de Medida</label>
              <select name="unidad_medida_id" class="form-select" required>
                <option value="">Seleccionar unidad</option>
                <?php $__currentLoopData = $unidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($u->id); ?>"><?php echo e($u->nombre); ?> (<?php echo e($u->simbolo); ?>)</option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>

            <div class="col-md-12 mb-2">
              <label class="form-label">Bodega</label>
              <select name="bodega_id" class="form-select">
                <option value="">Seleccionar bodega</option>
                <?php $__currentLoopData = $bodegas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($b->id); ?>"><?php echo e($b->nombre); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>

            <div class="col-md-12 mb-2">
              <label class="form-label">Proveedor</label>
              <select name="vendor_id" class="form-select">
                <option value="">Seleccionar proveedor</option>
                <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($v->id); ?>"><?php echo e($v->nombre); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>

            <div class="col-md-6 mb-2"><input type="number" step="0.01" name="precio_compra" class="form-control" placeholder="Precio de compra"></div>
            <div class="col-md-6 mb-2"><input type="number" step="0.01" name="precio_venta" class="form-control" placeholder="Precio de venta"></div>
            <div class="col-md-6 mb-2"><input type="number" step="0.01" name="stock_actual" class="form-control" placeholder="Stock actual"></div>
            <div class="col-md-6 mb-2"><input type="number" step="0.01" name="stock_minimo" class="form-control" placeholder="Stock mínimo"></div>

            <div class="col-md-12 mb-3">
              <label>Foto del Producto</label>
              <input type="file" name="foto" class="form-control">
            </div>

            <div class="col-md-12 mb-3">
              <select name="status" class="form-select" required>
                <option>Disponible</option>
                <option>Agotado</option>
                <option>Inactivo</option>
              </select>
            </div>
          </div>
          <button type="submit" class="btn btn-primary-custom w-100">Guardar</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded',()=>{
  const csrf=document.querySelector('meta[name="csrf-token"]').content;
  const showAlert=(icon,title,text,reload=false)=>{
    Swal.fire({icon,title,text,confirmButtonColor:'#FF4E02'}).then(()=>{if(reload)location.reload();});
  };

  // ➕ Nuevo Producto
  const newForm=document.getElementById('newProductoForm');
  if(newForm){
    newForm.addEventListener('submit',async e=>{
      e.preventDefault();
      const fd=new FormData(newForm);
      const res=await fetch('<?php echo e(route('inventario.store')); ?>',{method:'POST',headers:{'X-CSRF-TOKEN':csrf},body:fd});
      const data=await res.json();
      data.success?showAlert('success','Producto agregado','El nuevo producto fue guardado correctamente.',true):showAlert('error','Error','No se pudo guardar el producto.');
    });
  }

  // ✏️ Editar Producto
  document.querySelectorAll('.editProductoForm').forEach(form=>{
    form.addEventListener('submit',async e=>{
      e.preventDefault();
      const id=form.dataset.id;
      const fd=new FormData(form);
      const res=await fetch(`/inventario/${id}`,{method:'POST',headers:{'X-CSRF-TOKEN':csrf,'X-HTTP-Method-Override':'PUT'},body:fd});
      const data=await res.json();
      data.success?showAlert('success','Producto actualizado','Los cambios se guardaron correctamente.',true):showAlert('error','Error','No se pudo actualizar el producto.');
    });
  });

  // 🔍 Filtros
  const fName=document.getElementById('filterName');
  const fCat=document.getElementById('filterCategoria');
  const fStatus=document.getElementById('filterStatus');
  const rows=document.querySelectorAll('#inventarioTable tbody tr');

  function filter(){
    const n=fName.value.toLowerCase();
    const c=fCat.value.toLowerCase();
    const s=fStatus.value;
    rows.forEach(r=>{
      const name=r.cells[2].innerText.toLowerCase();
      const cat=r.cells[3].innerText.toLowerCase();
      const st=r.cells[9].innerText.trim();
      const show=(!n||name.includes(n))&&(!c||cat.includes(c))&&(!s||st===s);
      r.style.display=show?'':'none';
    });
  }
  [fName,fCat,fStatus].forEach(el=>{el.addEventListener('input',filter);el.addEventListener('change',filter);});
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/comercializadora/public_html/app.jdcomercializadora.com/resources/views/inventario/index.blade.php ENDPATH**/ ?>