

<?php $__env->startSection('title', 'Perfil - Trainsa'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-container">
  <style>
    .profile-card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        padding: 30px;
        max-width: 700px;
        margin: 0 auto;
    }
    .profile-card h3 {
        color: #1A3A5F;
        font-weight: 700;
        margin-bottom: 20px;
    }
    .form-label { font-weight: 600; color: #6B7280; }
    .btn-primary-custom {
        background-color: #FF6B35;
        border: none;
        color: #fff;
        font-weight: 600;
        padding: 10px 20px;
        border-radius: 8px;
    }
    .btn-primary-custom:hover { background-color: #E55A2B; }
  </style>

  <div class="page-header">
    <h1 class="page-title">Perfil</h1>
    <p class="page-subtitle">Administra tu información personal y contraseña.</p>
  </div>

  <?php if(session('success')): ?>
      <div class="alert alert-success"><?php echo e(session('success')); ?></div>
  <?php endif; ?>

  <?php if($errors->any()): ?>
      <div class="alert alert-danger">
          <ul class="mb-0">
              <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <li><?php echo e($error); ?></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
      </div>
  <?php endif; ?>

  <div class="profile-card mb-4">
    <h3><i class="fa-solid fa-user me-2"></i> Datos del Usuario</h3>
    <form action="<?php echo e(route('usuarios.updateProfile')); ?>" method="POST">
      <?php echo csrf_field(); ?>
      <div class="mb-3">
        <label class="form-label">Nombre</label>
        <input type="text" name="name" class="form-control" value="<?php echo e($user->name); ?>" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Correo Electrónico</label>
        <input type="email" name="email" class="form-control" value="<?php echo e($user->email); ?>" required>
      </div>
      <button type="submit" class="btn btn-primary-custom">Guardar Cambios</button>
    </form>
  </div>

  <div class="profile-card">
    <h3><i class="fa-solid fa-lock me-2"></i> Cambiar Contraseña</h3>
    <form action="<?php echo e(route('usuarios.updatePassword')); ?>" method="POST">
      <?php echo csrf_field(); ?>
      <div class="mb-3">
        <label class="form-label">Contraseña Actual</label>
        <input type="password" name="current_password" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Nueva Contraseña</label>
        <input type="password" name="new_password" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Confirmar Nueva Contraseña</label>
        <input type="password" name="new_password_confirmation" class="form-control" required>
      </div>
      <button type="submit" class="btn btn-primary-custom">Actualizar Contraseña</button>
    </form>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/comercializadora/public_html/app.jdcomercializadora.com/resources/views/usuarios/profile.blade.php ENDPATH**/ ?>