

<?php $__env->startSection('title', 'Conductores - Trainsa'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-container">
  <div class="page-header">
    <h1 class="page-title">Conductores</h1>
    <p class="page-subtitle">Gestión completa de conductores del sistema Trainsa.</p>
  </div>

  <!-- 📊 Stats -->
  <div class="row mb-4 justify-content-center">
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card total">
        <p class="stats-title">Total Conductores</p>
        <h2 class="stats-value"><?php echo e($total); ?></h2>
      </div>
    </div>

    <?php
      $statuses = [
        'Activo' => 'active',
        'Inactivo' => 'inactive',
        'Sin Camion' => 'no-truck',
        'Sin Licencia' => 'no-license',
        'En Descanso' => 'resting',
      ];
    ?>

    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado => $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="col-md-3 col-sm-6 mb-3">
        <div class="stats-card <?php echo e($class); ?>">
          <p class="stats-title"><?php echo e($estado); ?></p>
          <h2 class="stats-value"><?php echo e($por_estado[$estado] ?? 0); ?></h2>
        </div>
      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>

  <!-- 🚛 Table -->
  <div class="table-container">
    <div class="table-header">
      <h3 class="table-title">Lista de Conductores</h3>
      <button class="btn btn-primary-custom ms-auto" data-bs-toggle="modal" data-bs-target="#newConductorModal">
        <i class="fas fa-plus me-2"></i>Nuevo Conductor
      </button>
    </div>

    <!-- Filters -->
    <div class="p-3 bg-light border-bottom">
      <div class="row g-3">
        <div class="col-md-4">
          <input type="text" id="filterName" class="form-control" placeholder="Buscar por nombre...">
        </div>
        <div class="col-md-4">
          <input type="text" id="filterLicense" class="form-control" placeholder="Buscar por licencia...">
        </div>
        <div class="col-md-4">
          <select id="filterStatus" class="form-select">
            <option value="">Todos los estados</option>
            <option>Activo</option>
            <option>Inactivo</option>
            <option>Sin Camion</option>
            <option>Sin Licencia</option>
            <option>En Descanso</option>
          </select>
        </div>
      </div>
    </div>

    <div class="table-responsive">
      <table id="conductoresTable" class="table table-hover align-middle mb-0">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Foto</th>
            <th>Nombre</th>
            
            <th>Teléfono</th>
            <th>Licencia</th>
            <th>Tipo</th>
            <th>Vencimiento Licencia</th>
            <th>Apto Médico</th>
            <th>Tractor</th>
            <th>Estado</th>
            <th class="text-center">Acciones</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $conductores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($c->worker_number); ?></td>
            <td>
              <?php if($c->profile_pic): ?>
                <img src="<?php echo e(asset('storage/'.$c->profile_pic)); ?>" width="45" height="45" class="rounded-circle object-fit-cover">
              <?php else: ?>
                <i class="fa-solid fa-user text-secondary fs-4"></i>
              <?php endif; ?>
            </td>
            <td><?php echo e($c->first_name); ?> <?php echo e($c->last_name); ?></td>
            
            <td><?php echo e($c->phone_number); ?></td>
            <td><?php echo e($c->license_number); ?></td>
            <td><?php echo e($c->license_type); ?></td>
            <td><?php echo e($c->license_expiration); ?></td>
            <td><?php echo e($c->medical_exam_expiration); ?></td>
            <td><?php echo e($c->tractor_unidad ?? 'Ninguno'); ?></td>
            <td>
              <span class="badge 
                <?php switch($c->status):
                  case ('Activo'): ?> badge-active <?php break; ?>
                  <?php case ('Inactivo'): ?> badge-inactive <?php break; ?>
                  <?php case ('Sin Camion'): ?> badge-no-truck <?php break; ?>
                  <?php case ('Sin Licencia'): ?> badge-no-license <?php break; ?>
                  <?php case ('En Descanso'): ?> badge-resting <?php break; ?>
                  <?php default: ?> badge-inactive
                <?php endswitch; ?>">
                <?php echo e($c->status); ?>

              </span>
            </td>
            <td class="text-center">
              <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#viewModal<?php echo e($c->id); ?>"><i class="fas fa-eye"></i></button>
              <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#editModal<?php echo e($c->id); ?>"><i class="fas fa-edit"></i></button>
            </td>
          </tr>

          <!-- View Modal -->
          <div class="modal fade" id="viewModal<?php echo e($c->id); ?>" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Detalles del Conductor</h5>
                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <div class="row">
                    <div class="col-md-4 text-center">
                      <?php if($c->profile_pic): ?>
                        <img src="<?php echo e(asset('storage/'.$c->profile_pic)); ?>" width="120" class="rounded mb-2">
                      <?php endif; ?>
                    </div>
                    <div class="col-md-8">
                      <p><strong>Nombre:</strong> <?php echo e($c->first_name); ?> <?php echo e($c->last_name); ?></p>
                      <p><strong>Email:</strong> <?php echo e($c->email); ?></p>
                      <p><strong>Teléfono:</strong> <?php echo e($c->phone_number); ?></p>
                      <p><strong>Licencia:</strong> <?php echo e($c->license_number); ?> (<?php echo e($c->license_type); ?>)</p>
                      <p><strong>Expira:</strong> <?php echo e($c->license_expiration); ?></p>
                      <p><strong>Apto Médico:</strong> <?php echo e($c->medical_exam_number); ?> - <?php echo e($c->medical_exam_expiration); ?></p>
                      <p><strong>Estado:</strong> <?php echo e($c->status); ?></p>
                    </div>
                  </div>

                  <hr>
                  <p>
                    <?php if($c->license_front): ?>
                      <a href="<?php echo e(asset('storage/'.$c->license_front)); ?>" target="_blank">📄 Licencia Frente</a><br>
                    <?php endif; ?>
                    <?php if($c->license_back): ?>
                      <a href="<?php echo e(asset('storage/'.$c->license_back)); ?>" target="_blank">📄 Licencia Reverso</a><br>
                    <?php endif; ?>
                    <?php if($c->rfc_document): ?>
                      <a href="<?php echo e(asset('storage/'.$c->rfc_document)); ?>" target="_blank">📄 RFC</a><br>
                    <?php endif; ?>
                    <?php if($c->medical_exam_document): ?>
                      <a href="<?php echo e(asset('storage/'.$c->medical_exam_document)); ?>" target="_blank">📄 Apto Médico</a><br>
                    <?php endif; ?>
                  </p>
                </div>
              </div>
            </div>
          </div>

          <!-- Edit Modal -->
          <div class="modal fade" id="editModal<?php echo e($c->id); ?>" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Editar Conductor</h5>
                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <form class="editConductorForm" data-id="<?php echo e($c->id); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="row">
                      <div class="col-md-6 mb-2"><input type="text" name="first_name" class="form-control" value="<?php echo e($c->first_name); ?>" placeholder="Nombre" required></div>
                      <div class="col-md-6 mb-2"><input type="text" name="last_name" class="form-control" value="<?php echo e($c->last_name); ?>" placeholder="Apellido" required></div>
                      <div class="col-md-6 mb-2"><input type="email" name="email" class="form-control" value="<?php echo e($c->email); ?>" placeholder="Email" required></div>
                      <div class="col-md-6 mb-2"><input type="text" name="phone_number" class="form-control" value="<?php echo e($c->phone_number); ?>" placeholder="Teléfono"></div>
                      <div class="col-md-6 mb-2"><input type="text" name="worker_number" class="form-control" value="<?php echo e($c->worker_number); ?>" placeholder="Número de Trabajador"></div>
                      <div class="col-md-6 mb-2"><input type="text" name="rfc_id" class="form-control" value="<?php echo e($c->rfc_id); ?>" placeholder="RFC ID"></div>
                      <div class="col-md-6 mb-2"><input type="text" name="license_number" class="form-control" value="<?php echo e($c->license_number); ?>" placeholder="Número de Licencia"></div>
                      <div class="col-md-6 mb-2">
                        <select name="license_type" class="form-select">
                          <option value="">Tipo de Licencia</option>
                          <option <?php echo e($c->license_type=='B'?'selected':''); ?>>B</option>
                          <option <?php echo e($c->license_type=='E'?'selected':''); ?>>E</option>
                        </select>
                      </div>
                      <div class="col-md-6 mb-2"><input type="date" name="license_expiration" class="form-control" value="<?php echo e($c->license_expiration); ?>" placeholder="Vencimiento Licencia"></div>
                      <div class="col-md-6 mb-2"><input type="text" name="medical_exam_number" class="form-control" value="<?php echo e($c->medical_exam_number); ?>" placeholder="Número Apto Médico"></div>
                      <div class="col-md-6 mb-2"><input type="date" name="medical_exam_expiration" class="form-control" value="<?php echo e($c->medical_exam_expiration); ?>" placeholder="Vencimiento Apto Médico"></div>
                      <div class="col-md-6 mb-2"><input type="text" name="social_security_number" class="form-control" value="<?php echo e($c->social_security_number); ?>" placeholder="Seguro Social"></div>

                      <!-- 🖼️ File Uploads -->
                      <div class="col-md-6 mb-2"><label>Foto de Perfil</label><input type="file" name="profile_pic" class="form-control"></div>
                      <div class="col-md-6 mb-2"><label>Licencia Frente</label><input type="file" name="license_front" class="form-control"></div>
                      <div class="col-md-6 mb-2"><label>Licencia Reverso</label><input type="file" name="license_back" class="form-control"></div>
                      <div class="col-md-6 mb-2"><label>Documento RFC</label><input type="file" name="rfc_document" class="form-control"></div>
                      <div class="col-md-6 mb-2"><label>Documento Apto Médico</label><input type="file" name="medical_exam_document" class="form-control"></div>

                      <div class="col-md-12 mb-2">
                        <select name="status" class="form-select">
                          <option <?php echo e($c->status=='Activo'?'selected':''); ?>>Activo</option>
                          <option <?php echo e($c->status=='Inactivo'?'selected':''); ?>>Inactivo</option>
                          <option <?php echo e($c->status=='Sin Camion'?'selected':''); ?>>Sin Camion</option>
                          <option <?php echo e($c->status=='Sin Licencia'?'selected':''); ?>>Sin Licencia</option>
                          <option <?php echo e($c->status=='En Descanso'?'selected':''); ?>>En Descanso</option>
                        </select>
                      </div>
                    </div>
                    <button type="submit" class="btn btn-primary-custom w-100 mt-3">Guardar Cambios</button>
                  </form>
                </div>
              </div>
            </div>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>

    <div class="pagination-container p-3">
      <?php echo e($conductores->links('pagination::bootstrap-5')); ?>

    </div>
  </div>
</div>

<!-- ➕ Nuevo Conductor Modal -->
<div class="modal fade" id="newConductorModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">Nuevo Conductor</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="newConductorForm" enctype="multipart/form-data">
          <?php echo csrf_field(); ?>
          <div class="row">
            <div class="col-md-6 mb-2"><input type="text" name="first_name" class="form-control" placeholder="Nombre" required></div>
            <div class="col-md-6 mb-2"><input type="text" name="last_name" class="form-control" placeholder="Apellido" required></div>
            <div class="col-md-6 mb-2"><input type="email" name="email" class="form-control" placeholder="Email" required></div>
            <div class="col-md-6 mb-2"><input type="text" name="phone_number" class="form-control" placeholder="Teléfono"></div>
            <div class="col-md-6 mb-2"><input type="text" name="worker_number" class="form-control" placeholder="Número de Trabajador"></div>
            <div class="col-md-6 mb-2"><input type="text" name="rfc_id" class="form-control" placeholder="RFC ID"></div>
            <div class="col-md-6 mb-2"><input type="text" name="license_number" class="form-control" placeholder="Número de Licencia"></div>
            <div class="col-md-6 mb-2">
              <select name="license_type" class="form-select">
                <option value="">Tipo de Licencia</option>
                <option>B</option>
                <option>E</option>
              </select>
            </div>
            <div class="col-md-6 mb-2"><input type="date" name="license_expiration" class="form-control"></div>
            <div class="col-md-6 mb-2"><input type="text" name="medical_exam_number" class="form-control" placeholder="Número Apto Médico"></div>
            <div class="col-md-6 mb-2"><input type="date" name="medical_exam_expiration" class="form-control"></div>
            <div class="col-md-6 mb-2"><input type="text" name="social_security_number" class="form-control" placeholder="Seguro Social"></div>

            <!-- 🖼️ File uploads -->
            <div class="col-md-6 mb-2"><label>Foto de Perfil</label><input type="file" name="profile_pic" class="form-control"></div>
            <div class="col-md-6 mb-2"><label>Licencia Frente</label><input type="file" name="license_front" class="form-control"></div>
            <div class="col-md-6 mb-2"><label>Licencia Reverso</label><input type="file" name="license_back" class="form-control"></div>
            <div class="col-md-6 mb-2"><label>Documento RFC</label><input type="file" name="rfc_document" class="form-control"></div>
            <div class="col-md-6 mb-2"><label>Documento Apto Médico</label><input type="file" name="medical_exam_document" class="form-control"></div>

            <div class="col-md-12 mb-3">
              <select name="status" class="form-select" required>
                <option>Activo</option>
                <option>Inactivo</option>
                <option>Sin Camion</option>
                <option>Sin Licencia</option>
                <option>En Descanso</option>
              </select>
            </div>
          </div>
          <button type="submit" class="btn btn-primary-custom w-100">Guardar</button>
        </form>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>


<script>
document.addEventListener('DOMContentLoaded', () => {
    const csrf = document.querySelector('meta[name="csrf-token"]').content;

    // 🔹 Helper for SweetAlert notifications
    const showAlert = (icon, title, text, reload = false) => {
        Swal.fire({
            icon,
            title,
            text,
            confirmButtonColor: '#FF4E02'
        }).then(() => {
            if (reload) location.reload();
        });
    };

    // 🔹 New Conductor
    const newForm = document.getElementById('newConductorForm');
    if (newForm) {
        newForm.addEventListener('submit', async e => {
            e.preventDefault(); // stop form reload
            const formData = new FormData(newForm);

            try {
                const res = await fetch('<?php echo e(route('conductores.store')); ?>', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': csrf,
                        'Accept': 'application/json'
                    },
                    body: formData
                });

                const data = await res.json();

                if (data.success) {
                    showAlert('success', 'Conductor agregado', 'El nuevo conductor fue guardado correctamente.', true);
                } else {
                    showAlert('error', 'Error', 'No se pudo guardar el conductor.');
                }
            } catch (error) {
                console.error(error);
                showAlert('error', 'Error', 'Hubo un problema al guardar el conductor.');
            }
        });
    }

    // 🔹 Edit Conductor
    document.querySelectorAll('.editConductorForm').forEach(form => {
        form.addEventListener('submit', async e => {
            e.preventDefault(); // stop reload
            const id = form.dataset.id;
            const formData = new FormData(form);

            try {
                const res = await fetch(`/conductores/${id}`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': csrf,
                        'X-HTTP-Method-Override': 'PUT',
                        'Accept': 'application/json'
                    },
                    body: formData
                });

                const data = await res.json();

                if (data.success) {
                    showAlert('success', 'Conductor actualizado', 'Los datos se guardaron correctamente.', true);
                } else {
                    showAlert('error', 'Error al actualizar', 'Revisa los datos e intenta nuevamente.');
                }
            } catch (error) {
                console.error(error);
                showAlert('error', 'Error', 'Hubo un problema al actualizar el conductor.');
            }
        });
    });

    // 🔹 Filters
    const fName = document.getElementById('filterName');
    const fLic = document.getElementById('filterLicense');
    const fStatus = document.getElementById('filterStatus');
    const rows = document.querySelectorAll('#conductoresTable tbody tr');

    function filter() {
        const n = fName.value.toLowerCase();
        const l = fLic.value.toLowerCase();
        const s = fStatus.value;
        rows.forEach(r => {
            const name = r.cells[2].innerText.toLowerCase();
            const lic = r.cells[5].innerText.toLowerCase();
            const st = r.cells[10].innerText.trim();
            const show = (!n || name.includes(n)) && (!l || lic.includes(l)) && (!s || st === s);
            r.style.display = show ? '' : 'none';
        });
    }

    [fName, fLic, fStatus].forEach(el => {
        el.addEventListener('input', filter);
        el.addEventListener('change', filter);
    });
});
</script>




<?php echo $__env->make('layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/trainsa/public_html/resources/views/conductores/index.blade.php ENDPATH**/ ?>