<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Client;
use Illuminate\Support\Facades\DB;

class ClientController extends Controller
{
    public function index()
    {
        $clients = Client::orderBy('id', 'desc')->paginate(3);

        $total = Client::count();
        $activos = Client::where('status', 'Activo')->count();
        $inactivos = Client::where('status', 'Inactivo')->count();

        return view('clients.index', compact('clients', 'total', 'activos', 'inactivos'));
    }

    public function store(Request $request)
    {
        Client::create([
            'client' => $request->client,
            'contacts' => json_encode([$request->contact]),
            'email' => $request->email,
            'phone' => $request->phone,
            'status' => $request->status ?? 'Activo',
        ]);

        return response()->json(['success' => true]);
    }

    public function update(Request $request, $id)
    {
        $client = Client::findOrFail($id);
        $client->update([
            'client' => $request->client,
            'contacts' => json_encode([$request->contact]),
            'email' => $request->email,
            'phone' => $request->phone,
            'status' => $request->status,
        ]);

        return response()->json(['success' => true]);
    }
}
