<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class ConductorController extends Controller
{
   public function index()
{
    $conductores = DB::table('conductores as c')
        ->leftJoin('tractores as t', 't.conductor_id', '=', 'c.id')
        ->select('c.*', 't.unidad as tractor_unidad') // ✅ changed from plate → unidad
        ->orderBy('c.first_name')
        ->paginate(10);

    $total = DB::table('conductores')->count();

    $por_estado = DB::table('conductores')
        ->select('status', DB::raw('COUNT(*) as total'))
        ->groupBy('status')
        ->get()
        ->pluck('total', 'status');

    $all_statuses = ['Sin Camion', 'En Descanso', 'Sin Licencia', 'Inactivo', 'Activo'];
    foreach ($all_statuses as $estado) {
        if (!isset($por_estado[$estado])) {
            $por_estado[$estado] = 0;
        }
    }

    return view('conductores.index', compact('conductores', 'total', 'por_estado'));
}


    // ✅ Store conductor
    public function store(Request $request)
    {
        $validated = $request->validate([
            'first_name' => 'required|string|max:100',
            'last_name' => 'required|string|max:100',
            'email' => 'required|email|unique:conductores,email',
            'phone_number' => 'required|string|max:50',
            'date_of_birth' => 'nullable|date',
            'status' => 'required|string|max:50',
            'worker_number' => 'nullable|string|max:100',
            'rfc_id' => 'nullable|string|max:100',
            'license_number' => 'nullable|string|max:100',
            'license_type' => 'nullable|string|max:5',
            'license_expiration' => 'nullable|date',
            'medical_exam_number' => 'nullable|string|max:100',
            'medical_exam_expiration' => 'nullable|date',
            'social_security_number' => 'nullable|string|max:100',
            'profile_pic' => 'nullable|file|mimes:jpg,jpeg,png,webp|max:5120',
            'license_front' => 'nullable|file|mimes:jpg,jpeg,png,webp,pdf|max:5120',
            'license_back' => 'nullable|file|mimes:jpg,jpeg,png,webp,pdf|max:5120',
            'rfc_document' => 'nullable|file|mimes:jpg,jpeg,png,pdf|max:5120',
            'medical_exam_document' => 'nullable|file|mimes:jpg,jpeg,png,pdf|max:5120',
        ]);

        // Upload files if any
        $validated['profile_pic'] = $request->file('profile_pic')?->store('conductores/profile', 'public');
        $validated['license_front'] = $request->file('license_front')?->store('conductores/license', 'public');
        $validated['license_back'] = $request->file('license_back')?->store('conductores/license', 'public');
        $validated['rfc_document'] = $request->file('rfc_document')?->store('conductores/rfc', 'public');
        $validated['medical_exam_document'] = $request->file('medical_exam_document')?->store('conductores/aptos', 'public');

        DB::table('conductores')->insert($validated);

        return response()->json(['success' => true]);
    }

    // ✅ Update conductor
    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'first_name' => 'required|string|max:100',
            'last_name' => 'required|string|max:100',
            'email' => 'required|email|unique:conductores,email,' . $id,
            'phone_number' => 'required|string|max:50',
            'date_of_birth' => 'nullable|date',
            'status' => 'required|string|max:50',
            'worker_number' => 'nullable|string|max:100',
            'rfc_id' => 'nullable|string|max:100',
            'license_number' => 'nullable|string|max:100',
            'license_type' => 'nullable|string|max:5',
            'license_expiration' => 'nullable|date',
            'medical_exam_number' => 'nullable|string|max:100',
            'medical_exam_expiration' => 'nullable|date',
            'social_security_number' => 'nullable|string|max:100',
            'profile_pic' => 'nullable|file|mimes:jpg,jpeg,png,webp|max:5120',
            'license_front' => 'nullable|file|mimes:jpg,jpeg,png,webp,pdf|max:5120',
            'license_back' => 'nullable|file|mimes:jpg,jpeg,png,webp,pdf|max:5120',
            'rfc_document' => 'nullable|file|mimes:jpg,jpeg,png,pdf|max:5120',
            'medical_exam_document' => 'nullable|file|mimes:jpg,jpeg,png,pdf|max:5120',
        ]);

        // Upload new ones if provided
        if ($request->hasFile('profile_pic')) {
            $validated['profile_pic'] = $request->file('profile_pic')->store('conductores/profile', 'public');
        }
        if ($request->hasFile('license_front')) {
            $validated['license_front'] = $request->file('license_front')->store('conductores/license', 'public');
        }
        if ($request->hasFile('license_back')) {
            $validated['license_back'] = $request->file('license_back')->store('conductores/license', 'public');
        }
        if ($request->hasFile('rfc_document')) {
            $validated['rfc_document'] = $request->file('rfc_document')->store('conductores/rfc', 'public');
        }
        if ($request->hasFile('medical_exam_document')) {
            $validated['medical_exam_document'] = $request->file('medical_exam_document')->store('conductores/aptos', 'public');
        }

        DB::table('conductores')->where('id', $id)->update($validated);

        return response()->json(['success' => true]);
    }
}
