<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DollyController extends Controller
{
public function index()
{
    $dollys = DB::table('dollys as d')
        ->leftJoin('tractores as t', 'd.tractor_id', '=', 't.id')
        ->leftJoin('conductores as c1', 'd.conductor_id', '=', 'c1.id')
        ->leftJoin('conductores as c2', 't.conductor_id', '=', 'c2.id')
        ->select(
            'd.*',
            't.unidad as tractor_unidad', // ✅ correct field name
            DB::raw("COALESCE(CONCAT(c1.first_name, ' ', c1.last_name), CONCAT(c2.first_name, ' ', c2.last_name)) as conductor_name")
        )
        ->orderBy('d.id', 'desc')
        ->paginate(10);

    $total = DB::table('dollys')->count();

    $por_estado = DB::table('dollys')
        ->select('status', DB::raw('COUNT(*) as total'))
        ->groupBy('status')
        ->get()
        ->pluck('total', 'status');

    return view('dollys.index', compact('dollys', 'total', 'por_estado'));
}


    public function store(Request $request)
    {
        $validated = $request->validate([
            'unidad' => 'required|string|max:100',
            'marca' => 'nullable|string|max:100',
            'anio' => 'nullable|integer',
            'placa' => 'nullable|string|max:100|unique:dollys,placa',
            'niv' => 'nullable|string|max:100',
            'color' => 'nullable|string|max:50',
            'status' => 'required|string|max:50',
            'fisico_mecanica_doc' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:5120',
        ]);

        $data = $validated;
        if ($request->hasFile('fisico_mecanica_doc')) {
            $data['fisico_mecanica_doc'] = $request->file('fisico_mecanica_doc')->store('dollys_docs', 'public');
        }

        DB::table('dollys')->insert($data);

        return response()->json(['success' => true]);
    }

    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'unidad' => 'required|string|max:100',
            'marca' => 'nullable|string|max:100',
            'anio' => 'nullable|integer',
            'placa' => 'nullable|string|max:100',

            'niv' => 'nullable|string|max:100',
            'color' => 'nullable|string|max:50',
            'status' => 'required|string|max:50',
            'fisico_mecanica_doc' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:5120',
        ]);

        $updateData = $validated;
        if ($request->hasFile('fisico_mecanica_doc')) {
            $updateData['fisico_mecanica_doc'] = $request->file('fisico_mecanica_doc')->store('dollys_docs', 'public');
        }

        DB::table('dollys')->where('id', $id)->update($updateData);

        return response()->json(['success' => true]);
    }
}
