@extends('layouts.dashboard')

@section('title', 'Usuarios - Trainsa')

@section('content')

<body>
<div class="dashboard-container">
  <div class="page-header">
    <h1 class="page-title">Usuarios</h1>
    <p class="page-subtitle">Gestion de usuarios del sistema Trainsa.</p>
  </div>

  <!-- �9�6 Stats -->
  <div class="row mb-4 justify-content-center">
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card total">
        <p class="stats-title">Total Usuarios</p>
        <h2 class="stats-value">{{ $total }}</h2>
      </div>
    </div>
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card active">
        <p class="stats-title">Activos</p>
        <h2 class="stats-value">{{ $activos }}</h2>
      </div>
    </div>
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card inactive">
        <p class="stats-title">Inactivos</p>
        <h2 class="stats-value">{{ $inactivos }}</h2>
      </div>
    </div>
  </div>

  <!-- �0�3 Table -->
  <div class="table-container">
    <div class="table-header">
      <h3 class="table-title">Lista de Usuarios</h3>
      <button class="btn btn-primary-custom ms-auto" data-bs-toggle="modal" data-bs-target="#newUserModal">
        <i class="fas fa-plus me-2"></i>Nuevo Usuario
      </button>
    </div>

    <!-- Filters -->
    <div class="p-3 bg-light border-bottom">
      <div class="row g-3">
        <div class="col-md-4">
          <input type="text" id="filterName" class="form-control" placeholder="Buscar por nombre...">
        </div>
        <div class="col-md-4">
          <input type="text" id="filterEmail" class="form-control" placeholder="Buscar por correo...">
        </div>
        <div class="col-md-4">
          <select id="filterStatus" class="form-select">
            <option value="">Todos los estados</option>
            <option>Activo</option>
            <option>Inactivo</option>
          </select>
        </div>
      </div>
    </div>

    <div class="table-responsive">
      <table id="usuariosTable" class="table table-hover align-middle mb-0">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Nombre</th>
            <th>Email</th>
            <th>Estado</th>
            <th class="text-center">Acciones</th>
          </tr>
        </thead>
        <tbody>
          @foreach($usuarios as $u)
          <tr>
            <td>{{ $u->id }}</td>
            <td>{{ $u->name }}</td>
            <td>{{ $u->email }}</td>
            <td>
              <span class="badge {{ $u->status == 'Activo' ? 'badge-active' : 'badge-inactive' }}">
                {{ $u->status }}
              </span>
            </td>
            <td class="text-center">
              <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#editModal{{ $u->id }}"><i class="fas fa-edit"></i></button>
            </td>
          </tr>

          <!-- Edit Modal -->
          <div class="modal fade" id="editModal{{ $u->id }}" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Editar Usuario</h5>
                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <form class="editUserForm" data-id="{{ $u->id }}">
                    @csrf
                    @method('PUT')
                    <input type="text" name="name" class="form-control mb-2" value="{{ $u->name }}" placeholder="Nombre" required>
                    <input type="email" name="email" class="form-control mb-2" value="{{ $u->email }}" placeholder="Email" required>
                    <select name="status" class="form-select mb-3">
                      <option {{ $u->status == 'Activo' ? 'selected' : '' }}>Activo</option>
                      <option {{ $u->status == 'Inactivo' ? 'selected' : '' }}>Inactivo</option>
                    </select>
                    <button type="submit" class="btn btn-primary-custom w-100">Guardar Cambios</button>
                  </form>
                </div>
              </div>
            </div>
          </div>
          @endforeach
        </tbody>
      </table>
    </div>

    <div class="pagination-container p-3">
      {{ $usuarios->links('pagination::bootstrap-5') }}
    </div>
  </div>
</div>

<!-- �7�7 New User Modal -->
<div class="modal fade" id="newUserModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">Nuevo Usuario</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="newUserForm">
          @csrf
          <input type="text" name="name" class="form-control mb-2" placeholder="Nombre" required>
          <input type="email" name="email" class="form-control mb-2" placeholder="Email" required>
          <input type="password" name="password" class="form-control mb-2" placeholder="Contrase�0�9a" required>
          <select name="status" class="form-select mb-3">
            <option>Activo</option>
            <option>Inactivo</option>
          </select>
          <button type="submit" class="btn btn-primary-custom w-100">Guardar</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded',()=>{
  const csrf=document.querySelector('meta[name="csrf-token"]').content;
  const filterName=document.getElementById('filterName');
  const filterEmail=document.getElementById('filterEmail');
  const filterStatus=document.getElementById('filterStatus');
  const rows=document.querySelectorAll('#usuariosTable tbody tr');

  function filterTable(){
    const n=filterName.value.toLowerCase();
    const e=filterEmail.value.toLowerCase();
    const s=filterStatus.value;
    rows.forEach(r=>{
      const name=r.cells[1].innerText.toLowerCase();
      const email=r.cells[2].innerText.toLowerCase();
      const status=r.cells[3].innerText.trim();
      const show=(!n||name.includes(n))&&(!e||email.includes(e))&&(!s||status===s);
      r.style.display=show?'':'none';
    });
  }
  [filterName,filterEmail,filterStatus].forEach(el=>{
    el.addEventListener('input',filterTable);
    el.addEventListener('change',filterTable);
  });

  document.getElementById('newUserForm').addEventListener('submit',async e=>{
    e.preventDefault();
    const res=await fetch('{{ route('usuarios.store') }}',{method:'POST',headers:{'X-CSRF-TOKEN':csrf,'Accept':'application/json'},body:new FormData(e.target)});
    const d=await res.json();
    if(d.success){alert('Usuario agregado');location.reload();}
  });

  document.querySelectorAll('.editUserForm').forEach(f=>{
    f.addEventListener('submit',async e=>{
      e.preventDefault();
      const id=f.dataset.id;
      const res=await fetch(`/usuarios/${id}`,{method:'POST',headers:{'X-CSRF-TOKEN':csrf,'X-HTTP-Method-Override':'PUT','Accept':'application/json'},body:new FormData(f)});
      const d=await res.json();
      if(d.success){alert('Usuario actualizado');location.reload();}
    });
  });
});
</script>
</body>

@endsection
