@extends('layouts.dashboard')

@section('title', 'Perfil - Trainsa')

@section('content')
<div class="dashboard-container">
  <style>
    .profile-card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        padding: 30px;
        max-width: 700px;
        margin: 0 auto;
    }
    .profile-card h3 {
        color: #1A3A5F;
        font-weight: 700;
        margin-bottom: 20px;
    }
    .form-label { font-weight: 600; color: #6B7280; }
    .btn-primary-custom {
        background-color: #FF6B35;
        border: none;
        color: #fff;
        font-weight: 600;
        padding: 10px 20px;
        border-radius: 8px;
    }
    .btn-primary-custom:hover { background-color: #E55A2B; }
  </style>

  <div class="page-header">
    <h1 class="page-title">Perfil</h1>
    <p class="page-subtitle">Administra tu información personal y contraseña.</p>
  </div>

  @if(session('success'))
      <div class="alert alert-success">{{ session('success') }}</div>
  @endif

  @if($errors->any())
      <div class="alert alert-danger">
          <ul class="mb-0">
              @foreach($errors->all() as $error)
                  <li>{{ $error }}</li>
              @endforeach
          </ul>
      </div>
  @endif

  <div class="profile-card mb-4">
    <h3><i class="fa-solid fa-user me-2"></i> Datos del Usuario</h3>
    <form action="{{ route('usuarios.updateProfile') }}" method="POST">
      @csrf
      <div class="mb-3">
        <label class="form-label">Nombre</label>
        <input type="text" name="name" class="form-control" value="{{ $user->name }}" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Correo Electrónico</label>
        <input type="email" name="email" class="form-control" value="{{ $user->email }}" required>
      </div>
      <button type="submit" class="btn btn-primary-custom">Guardar Cambios</button>
    </form>
  </div>

  <div class="profile-card">
    <h3><i class="fa-solid fa-lock me-2"></i> Cambiar Contraseña</h3>
    <form action="{{ route('usuarios.updatePassword') }}" method="POST">
      @csrf
      <div class="mb-3">
        <label class="form-label">Contraseña Actual</label>
        <input type="password" name="current_password" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Nueva Contraseña</label>
        <input type="password" name="new_password" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Confirmar Nueva Contraseña</label>
        <input type="password" name="new_password_confirmation" class="form-control" required>
      </div>
      <button type="submit" class="btn btn-primary-custom">Actualizar Contraseña</button>
    </form>
  </div>
</div>
@endsection
