

<?php $__env->startSection('title', 'Clientes - Trainsa'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-container">
  <div class="page-header">
    <h1 class="page-title">Clientes</h1>
    <p class="page-subtitle">Gestión de clientes y contactos del sistema Trainsa.</p>
  </div>

  <!-- 📊 Stats -->
  <div class="row mb-4 justify-content-center">
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card total">
        <p class="stats-title">Total Clientes</p>
        <h2 class="stats-value"><?php echo e($total); ?></h2>
      </div>
    </div>
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card active">
        <p class="stats-title">Activos</p>
        <h2 class="stats-value"><?php echo e($activos); ?></h2>
      </div>
    </div>
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card inactive">
        <p class="stats-title">Inactivos</p>
        <h2 class="stats-value"><?php echo e($inactivos); ?></h2>
      </div>
    </div>
  </div>

  <!-- 🧾 Table -->
  <div class="table-container">
    <div class="table-header">
      <h3 class="table-title">Lista de Clientes</h3>
      <button class="btn btn-primary-custom ms-auto" data-bs-toggle="modal" data-bs-target="#newClientModal">
        <i class="fas fa-plus me-2"></i>Nuevo Cliente
      </button>
    </div>

    <div class="table-responsive">
      <table id="clientsTable" class="table table-hover align-middle mb-0">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Cliente</th>
            <th>Contacto</th>
            <th>Correo</th>
            <th>Teléfono</th>
            <th>Estado</th>
            <th class="text-center">Acciones</th>
          </tr>
        </thead>
        <tbody>
          <?php $row = 1; ?>
          <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
              if (is_array($c->contacts)) {
                  $contacts = $c->contacts;
              } else {
                  $contacts = json_decode($c->contacts ?? '[]', true);
              }
            ?>

            <?php if(!empty($contacts)): ?>
              <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                  $contactName = $contact['name'] ?? (is_array($contact) ? json_encode($contact) : $contact);
                  $contactEmail = $contact['email'] ?? $c->email;
                  $contactPhone = $contact['phone'] ?? $c->phone;
                ?>
                <tr>
                  <td><?php echo e($row++); ?></td>
                  <td><?php echo e($c->client); ?></td>
                  <td><?php echo e($contactName); ?></td>
                  <td><?php echo e($contactEmail); ?></td>
                  <td><?php echo e($contactPhone); ?></td>
                  <td>
                    <span class="badge <?php echo e($c->status == 'Activo' ? 'badge-active' : 'badge-inactive'); ?>">
                      <?php echo e($c->status); ?>

                    </span>
                  </td>
                  <td class="text-center">
                    <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#editContactModal<?php echo e($c->id); ?><?php echo e($index); ?>">
                      <i class="fas fa-edit"></i>
                    </button>
                  </td>
                </tr>

                <!-- 🟡 Edit Modal for each contact -->
                <div class="modal fade" id="editContactModal<?php echo e($c->id); ?><?php echo e($index); ?>" tabindex="-1" aria-hidden="true">
                  <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                      <div class="modal-header bg-dark text-white">
                        <h5 class="modal-title">Editar Contacto - <?php echo e($c->client); ?></h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                      </div>
                      <div class="modal-body">
                        <form class="editContactForm" data-id="<?php echo e($c->id); ?>" data-index="<?php echo e($index); ?>">
                          <?php echo csrf_field(); ?>
                          <?php echo method_field('PUT'); ?>
                          <input type="text" name="client" class="form-control mb-2" value="<?php echo e($c->client); ?>" readonly>
                          <input type="text" name="contact_name" class="form-control mb-2" value="<?php echo e($contactName); ?>" placeholder="Nombre del contacto" required>
                          <input type="email" name="contact_email" class="form-control mb-2" value="<?php echo e($contactEmail); ?>" placeholder="Correo del contacto">
                          <input type="text" name="contact_phone" class="form-control mb-2" value="<?php echo e($contactPhone); ?>" placeholder="Teléfono del contacto">
                          <select name="status" class="form-select mb-3">
                            <option <?php echo e($c->status == 'Activo' ? 'selected' : ''); ?>>Activo</option>
                            <option <?php echo e($c->status == 'Inactivo' ? 'selected' : ''); ?>>Inactivo</option>
                          </select>
                          <button type="submit" class="btn btn-primary-custom w-100">Guardar Cambios</button>
                        </form>
                      </div>
                    </div>
                  </div>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
              <tr>
                <td><?php echo e($row++); ?></td>
                <td><?php echo e($c->client); ?></td>
                <td colspan="3"><em class="text-muted">Sin contactos</em></td>
                <td>
                  <span class="badge <?php echo e($c->status == 'Activo' ? 'badge-active' : 'badge-inactive'); ?>">
                    <?php echo e($c->status); ?>

                  </span>
                </td>
                <td class="text-center">
                  <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#editClientModal<?php echo e($c->id); ?>">
                    <i class="fas fa-edit"></i>
                  </button>
                </td>
              </tr>
            <?php endif; ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>

    <div class="pagination-container p-3">
      <?php echo e($clients->links('pagination::bootstrap-5')); ?>

    </div>
  </div>
</div>

<!-- 🆕 New Client Modal -->
<div class="modal fade" id="newClientModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">Nuevo Cliente</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="newClientForm">
          <?php echo csrf_field(); ?>
          <input type="text" name="client" class="form-control mb-2" placeholder="Cliente" required>
          <input type="text" name="contact_name" class="form-control mb-2" placeholder="Nombre de contacto" required>
          <input type="email" name="contact_email" class="form-control mb-2" placeholder="Correo del contacto">
          <input type="text" name="contact_phone" class="form-control mb-2" placeholder="Teléfono del contacto">
          <select name="status" class="form-select mb-3">
            <option>Activo</option>
            <option>Inactivo</option>
          </select>
          <button type="submit" class="btn btn-primary-custom w-100">Guardar</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded',()=>{
  const csrf=document.querySelector('meta[name="csrf-token"]').content;

  // 🆕 Create new client
  document.getElementById('newClientForm').addEventListener('submit',async e=>{
    e.preventDefault();
    const res=await fetch('<?php echo e(route('clients.store')); ?>',{
      method:'POST',
      headers:{'X-CSRF-TOKEN':csrf,'Accept':'application/json'},
      body:new FormData(e.target)
    });
    const d=await res.json();
    if(d.success){alert('Cliente agregado');location.reload();}
  });

  // ✏️ Update single contact
  document.querySelectorAll('.editContactForm').forEach(f=>{
    f.addEventListener('submit',async e=>{
      e.preventDefault();
      const id=f.dataset.id;
      const index=f.dataset.index;
      const data=new FormData(f);
      data.append('contact_index', index);

      const res=await fetch(`/clients/${id}`,{
        method:'POST',
        headers:{
          'X-CSRF-TOKEN':csrf,
          'X-HTTP-Method-Override':'PUT',
          'Accept':'application/json'
        },
        body:data
      });

      const d=await res.json();
      if(d.success){alert('Contacto actualizado');location.reload();}
    });
  });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/trainsa/public_html/resources/views/clients/index.blade.php ENDPATH**/ ?>