<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Color de la barra en navegadores compatibles -->
<meta name="theme-color" content="#1A3A5F" media="(prefers-color-scheme: light)">
<meta name="theme-color" content="#1A3A5F" media="(prefers-color-scheme: dark)">

<!-- iOS / Safari -->
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"> <!-- iOS 15+ toma theme-color -->

<!-- Windows / Edge tiles -->
<meta name="msapplication-TileColor" content="#1A3A5F">
<meta name="msapplication-navbutton-color" content="#1A3A5F">

<!-- Pinned tab Safari (opcional si tienes el SVG) -->
<link rel="mask-icon" href="/safari-pinned-tab.svg" color="#1A3A5F">

    <title>Login - Trainsa</title>
    <link rel="icon" sizes="32x32" href="<?php echo e(asset('public/favicontrainsa.png')); ?>">
<link rel="apple-touch-icon" href="<?php echo e(asset('public/favicontrainsa.png')); ?>">

    <style>
        :root {
            --primary: #FF4E02;
            --primary-dark: #E55A2B;
            --darkblue: #1A3A5F;
            --grayish: #6B7280;
            --light-gray: #F3F4F6;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: var(--light-gray);
            min-height: 100vh;
            display: flex;
        }

        /* === Left side (image) === */
        .image-section {
            width: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: var(--darkblue);
            position: relative;
            overflow: hidden;
        }

        .image-container {
            width: 80%;
            max-width: 500px;
            height: 400px;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
            position: relative;
            z-index: 2;
            animation: fadeIn 1.2s ease-out forwards;
        }

        .truck-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s ease;
        }

        .image-container:hover .truck-image {
            transform: scale(1.05);
        }

        .image-overlay {
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(26, 58, 95, 0.7) 0%, rgba(26, 58, 95, 0.3) 100%);
            z-index: 1;
        }

        .floating-logo {
            position: absolute;
            top: 30px;
            left: 30px;
            z-index: 3;
        }

        .floating-logo img {
            height: 50px;
            filter: brightness(0) invert(1);
        }

        /* === Right side (form) === */
        .form-section {
            width: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: white;
            flex-direction: column;
        }

        .mobile-header {
            display: none;
            width: 100%;
            background-color: var(--darkblue);
            padding: 15px 0;
            text-align: center;
        }

        .mobile-header img {
            height: 45px;
           
        }

        .form-container {
            width: 100%;
            max-width: 400px;
            padding: 40px;
        }

        .logo {
            display: flex;
            justify-content: center;
            margin-bottom: 30px;
        }

        .logo img {
            height: 70px;
        }

        h2 {
            font-size: 28px;
            font-weight: 600;
            text-align: center;
            color: var(--darkblue);
            margin-bottom: 30px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            color: var(--grayish);
            font-weight: 500;
        }

        input {
            width: 100%;
            padding: 14px 16px;
            border: 1.5px solid #E5E7EB;
            border-radius: 8px;
            font-size: 16px;
            transition: all 0.3s ease;
        }

        input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.2);
        }

        .submit-btn {
            width: 100%;
            background-color: var(--primary);
            color: white;
            border: none;
            padding: 14px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s ease;
            margin-top: 10px;
        }

        .submit-btn:hover {
            background-color: var(--primary-dark);
        }

        .footer {
            text-align: center;
            margin-top: 30px;
            color: var(--grayish);
            font-size: 14px;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* === Responsive === */
        @media (max-width: 768px) {
            body {
                flex-direction: column;
            }

            .image-section {
                display: none;
            }

            .form-section {
                width: 100%;
            }

            .mobile-header {
                display: block;
            }

            .form-container {
                padding: 30px 20px;
            }

            /* Hide logo inside form on mobile */
            .logo {
                display: none;
            }
        }
    </style>
</head>

<body>
    <!-- Left side (image) -->
    <div class="image-section">
        <div class="floating-logo">
            <img src="<?php echo e(asset('public/logotrainsa.png')); ?>" alt="Trainsa Logo">
        </div>
        <div class="image-container">
            <img src="<?php echo e(asset('public/camiones.jpg')); ?>" alt="Camiones Trainsa" class="truck-image">
        </div>
        <div class="image-overlay"></div>
    </div>

    <!-- Right side (form) -->
    <div class="form-section">
        <!-- Mobile header -->
        <div class="mobile-header">
            <img src="<?php echo e(asset('public/logotrainsa.png')); ?>" alt="Trainsa Logo">
        </div>

        <div class="form-container">
            <div class="logo">
                <img src="<?php echo e(asset('public/logotrainsa.png')); ?>" alt="Trainsa Logo">
            </div>

            <h2>Iniciar Sesión</h2>

            <form method="POST" action="<?php echo e(route('login.post')); ?>">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label for="email">Correo electrónico</label>
                    <input id="email" name="email" type="email" placeholder="tu@correo.com" required>
                </div>

                <div class="form-group">
                    <label for="password">Contraseña</label>
                    <input id="password" name="password" type="password" placeholder="********" required>
                </div>

                <button type="submit" class="submit-btn">Entrar</button>

                <?php if($errors->any()): ?>
                    <p style="color: red; margin-top: 10px; text-align:center;">
                        <?php echo e($errors->first()); ?>

                    </p>
                <?php endif; ?>
            </form>

            <p class="footer">
                © <?php echo e(date('Y')); ?> Trainsa. Todos los derechos reservados.
            </p>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/trainsa/public_html/resources/views/auth/login.blade.php ENDPATH**/ ?>